import { default as api, url } from '~/api';

export default async ({ commit }) => {
    const data = await api.get('vue_api', { get: 'process' });
    commit('SET_UPDATE_PID', 0);
    commit('SET_UPDATE_STATUS', false);
    commit('SET_UPDATE_LIVE_FLAG', false);
    if (data.status) {
        // Initial data setup
        commit('SET_UPDATE_LOG', '');
        commit('SET_UPDATE_STATUS', true);
        commit('SET_UPDATE_LIVE_FLAG', true);

        const source = new EventSource(
            `${url('show_log_sse')}?pid=${data.pid}&logfile=${data.logfile}`,
            { withCredentials: true },
        );
        console.log('source opened');

        const closeSource = () => {
            commit('SET_UPDATE_STATUS', false);
            commit('SET_UPDATE_PID', 0);
            source.close();
            console.log(' source closed');
        };

        source.addEventListener(
            'message',
            (e) => {
                const { data, finished, pid } = JSON.parse(e.data);
                if (finished) {
                    closeSource();
                }
                if (pid && pid !== '0') {
                    commit('SET_UPDATE_PID', Number(pid));
                }
                if (data) {
                    commit('SET_UPDATE_LOG', data);
                }
            },
            false
        );

        source.addEventListener(
            'error',
            (e) => {
                if (e.readyState === EventSource.CLOSED) {
                    commit('SET_UPDATE_STATUS', false);
                    commit('SET_UPDATE_PID', 0);
                    commit('SET_UPDATE_LIVE_FLAG', false);
                    throw new Error('Connection was closed');
                } else {
                    throw new Error('EventSource Error');
                }
            },
            false
        );
    }
};