import store from '~/store';

export const url = action => `/CMD_PLUGINS_ADMIN/${VueRoot.$route.params.id}/${action}.raw`;

const notifyError = error => store.dispatch(
        'notifications/NOTIFY',
        {
            theme: 'danger',
            title: 'CustomBuild',
            content: error.message,
            time: new Date(),
            route: window.Evolution.route.path,
        }
    );

export default {
    get: async (action, params) => {
        try {
            const response = await window.Evolution.axios.get(
                url(action),
                { params }
            );
            return response.data;
        } catch (error) {
            notifyError(error);
            return {};
        }
    },
    post: async (action, data) => {
        try {
            const response = await window.Evolution.axios.post(
                url(action),
                data,
            );
            return response.data;
        } catch (error) {
            notifyError(error);
            return {};
        }
    },
};