const { GettextExtractor, JsExtractors, HtmlExtractors } = require('gettext-extractor');

const AttributeInterpolationExtractor = (node, fileName, addMessage) => {
    const attrs = (node.attrs || [])
        .filter(attr => attr.value.includes('ettext('))
        .map(attr => attr.value);
    if (attrs.length) {
        const parser = new GettextExtractor();
        const jsParser = parser.createJsParser([
            JsExtractors.callExpression('$gettext', {
                arguments: { text: 0 },
            }),
            JsExtractors.callExpression('$ngettext', {
                arguments: {
                    text: 0,
                    textPlural: 1,
                },
            }),
        ]);
        attrs.forEach(attr => jsParser.parseString(attr));
        parser.getMessages().forEach(addMessage);
    }
};

const jsParserConfig = [
    JsExtractors.callExpression('[this].$gettext', {
        arguments: { text: 0 },
    }),
    JsExtractors.callExpression('[this].$ngettext', {
        arguments: {
            text: 0,
            textPlural: 1,
        },
    }),
    JsExtractors.callExpression('$gettext', {
        arguments: { text: 0 },
    }),
    JsExtractors.callExpression('$ngettext', {
        arguments: {
            text: 0,
            textPlural: 1,
        },
    }),
];

const htmlParserConfig = [
    HtmlExtractors.elementContent('translate, [v-translate]', {
        attributes: { textPlural: 'translate-plural' },
    }),
    AttributeInterpolationExtractor,
];

const extract = (glob, filename) => {
    const extractor = new GettextExtractor();
    extractor.createJsParser(jsParserConfig)
        .parseFilesGlob(glob.js);

    extractor
        .createHtmlParser(htmlParserConfig)
        .parseFilesGlob(glob.html);

    extractor.savePotFile(filename);
    extractor.printStats();
};

extract(
    {
        js: './src/{,**/}*.@(vue|js)',
        html: './src/{,**/}*.vue',
    },
    './dictionary.pot'
);