#!/bin/sh
#CustomBuild 2.0 plugin installation script
#Written by Martynas Bendorius, www.martynas.it

OS=`uname`
DEBIAN_VERSION=/etc/debian_version

#Update DA
echo "action=update&value=program" >> /usr/local/directadmin/data/task.queue

addUserGroup() {
	if [ ${OS} = "FreeBSD" ]; then
		PW=/usr/sbin/pw
		if ! /usr/bin/grep -q "^${2}:" < /etc/group; then
			${PW} groupadd ${2}
		fi
		if ! /usr/bin/id ${1} > /dev/null; then
			${PW} useradd -g ${2} -n ${1} -s /sbin/nologin
		fi
	elif [ -e ${DEBIAN_VERSION} ]; then
		if ! /usr/bin/id ${1} > /dev/null; then
			adduser --system --group --no-create-home \
		            --disabled-login --force-badname ${1} > /dev/null
		fi
	else
		if ! /usr/bin/id ${1} > /dev/null; then				
			/usr/sbin/useradd -r -s /bin/false ${1}
		fi
	fi
}

addUserGroup cb_plugin cb_plugin

echo "CustomBuild plugin is now installed!";
PATH=/usr/kerberos/sbin:/usr/kerberos/bin:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/root/bin
export PATH="$PATH"

FULLPATH=/usr/local/directadmin/plugins/custombuild
cd ${FULLPATH}
chmod -R 755 ${FULLPATH}/admin
chown -R diradmin:diradmin ${FULLPATH}/admin

chown diradmin:diradmin ${FULLPATH}/plugin.conf
chmod 644 ${FULLPATH}/plugin.conf

mkdir -p ${FULLPATH}/configure
chmod 700 ${FULLPATH}/configure
chown -R cb_plugin:cb_plugin ${FULLPATH}/configure

mkdir -p ${FULLPATH}/logs
chmod 700 ${FULLPATH}/logs
chown -R cb_plugin:cb_plugin ${FULLPATH}/logs

GCC=gcc
if [ -e /usr/bin/gcc ]; then
	GCC=/usr/bin/gcc
elif [ -e /usr/local/bin/gcc ]; then
	GCC=/usr/local/bin/gcc
elif [ -e /bin/gcc ]; then
	GCC=/bin/gcc
fi
${GCC} -std=gnu99 -B/usr/bin -o ${FULLPATH}/admin/build ${FULLPATH}/admin/build.c
chown root:admin ${FULLPATH}/admin/build
chmod 4755 ${FULLPATH}/admin/build

chmod -R 700 ${FULLPATH}/scripts
chown -R diradmin:diradmin ${FULLPATH}/scripts

/usr/local/directadmin/custombuild/build update_script > /dev/null 2>&1

exit 0;
