<script>

var notifications = $('#notifications');

$('document').ready(function () {

    /**
     * Bootstrap initialization
     */
    $('.btn').button();
    $('.badge').popover({html: true, container: 'body', placement: 'top', trigger: 'hover', delay: { hide: 1000 }});

    /**
     * Make buttons change radio input value
     */
    $('.btn').on('click', function () {
        var parent = $(this).parent();
        parent.find('input:checked').attr('checked', false);
        $(this).find('input').attr('checked', true);
    });

    $(window).resize(function() {
        $('.badge').popover('hide');
    });

    var contentBody     = $('#modal-body');
    var modalBody       = $('#progress-modal');
    var closeButton     = $('#modal-close-button');
    var responseCount   = 0;
    var xhr             = null;

    modalBody.on('hide.bs.modal', function() {
        if(xhr) {
            xhr.abort();
        }
        if(typeof reload_after_close !== 'undefined') {
            location.reload();
        }
    });

    <?php if(($pid = inProgress())) { ?>
    disableForms();
    checkProcess();
    <?php } ?>


    function retrieveValues(list) {
        const diff = {};
        for (var key in list) {
            const selector = '[name="' + key + '"]';
            let el = $(selector);
            var group = '';
            if (el) {
                const groupEl = el.parents('[data-group]');
                if (groupEl.length) {
                    group = groupEl[0].dataset.group;
                }
            }
            
            if (el.attr('type') === 'radio') {
                el = $(selector + ':checked');
            }
            const value = el ? el.val() : list[key];
            if (group && value && value !== list[key]) {
                if (typeof diff[group] === 'undefined') {
                    diff[group] = {};
                }
                diff[group][key] = value;
            }
        }
        return diff;
    }

    $('#edit_options_submit_button:not(:disabled)').on('click', function () {

        var button = $(this);
        button.button('loading');

        const diff = {};
        for (var group in currentSettings) {
            const vars = currentSettings[group];
            const inputs = Object.keys(vars);
            for (key of inputs){
                const selector = `[name="${group}:${key}"]`;
                let el = $(selector);
                if (el.attr('type') === 'radio') {
                    el = $(selector + ':checked');
                }
                if (el) {
                    const value = el.val();
                    if (value && value !== currentSettings[group][key]) {
                        if (typeof diff[group] === 'undefined') {
                            diff[group] = {};
                        }
                        diff[group][key] = value;
                    }
                }
            }
        }

        $.ajax({
            url: 'update_command.raw',
            data: JSON.stringify(diff),
            method: 'POST',
            dataType: 'json',
            success: function (data) {
                notifications.empty();

                if (data.messages.length > 0) {
                    for (var i = 0; i < data.messages.length; i++) {
                        var message = data.messages[i];
                        createNotification(message.status, message.message);
                        if(message.status == 'success') {
                            setTimeout(function() {window.location.reload()}, 2000);
                        }
                    }
                } else {
                    createNotification('info', 'No changes have been made');
                }

                Object
                    .entries(diff)
                    .forEach(
                        ([group, values]) => Object.assign(currentSettings[group], values)
                    );
                button.button('reset');

                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
            }
        });

        return false;
    });


    $('.buildButton:not(:disabled), .buildAllButton:not(:disabled)').on('click', function () {

        var button = $(this);
        var last_response_len = false;
        var contentBody = $('#modal-body');
        var responseCount = 1;

        preBuild();
        contentBody.append('<div>Executing /usr/local/directadmin/plugins/custombuild/admin/build ' + button.data('build') + '<span id="dots"></span></div>');

        xhr = $.ajax({
            url: 'build_software_command.raw',
            method: 'POST',
            async: true,
            data: JSON.stringify({'command': button.data('build')}),
            xhrFields: {
                onprogress: function (e) {
                    var this_response, response = e.currentTarget.response;
                    if (last_response_len === false) {
                        this_response = response;
                        last_response_len = response.length;
                    }
                    else {
                        this_response = response.substring(last_response_len);
                        last_response_len = response.length;
                    }
                    contentBody.append(this_response);
                    scrollDown();
                    responseCount++;
                }
            }
        }).done(function (data) {
            if (contentBody.text().length === 0 || responseCount === 2) {
                contentBody.append(data);
            }
            afterBuild('Done!')
        });

        setTimeout(function() { checkProcess() }, 1000);

    });

    $('.removeButton').on('click', function() {
        var button = $(this);
        $.ajax({
            url: 'remove_log.raw',
            method: 'POST',
            data: JSON.stringify({'logFile': button.data('log')}),
            success: function() {
                button.parents('tr').fadeOut('slow');
            }
        });
    });

    $('.previewButton').on('click', function() {
        var button = $(this);
        var contentBody = $('#modal-log-body');
        var modalBody = $('#log-modal');

        contentBody.empty();
        modalBody.modal('show');

        $.ajax({
            url: 'preview_log.raw',
            method: 'POST',
            dataType: 'json',
            data: JSON.stringify({'logFile': button.data('log')}),
            success: function (data) {
                contentBody.append(data.content);
            }
        });

    });

    $('.headerUpdateButton').on('click', function() {
        var button = $(this);
        button.button('loading');
        $.ajax({
            url: 'build_software_command.raw',
            method: 'POST',
            data: JSON.stringify({'command': button.data('update')}),
            success: function() {
                window.location.reload();
            }
        });
    });

    function preBuild()
    {
        contentBody.empty();
        modalBody.modal('show');
        $('.progress').show();
        closeButton.button('loading');
        startLoading();
    }

    $('.updateButton:not(:disabled), #update_all_button:not(:disabled)').on('click', function () {

        var button = $(this);
        var last_response_len = false;
        var contentBody = $('#modal-body');
        responseCount = 1;

        preBuild();
        contentBody.append('<div>Executing /usr/local/directadmin/plugins/custombuild/admin/build ' + button.data('update') + '<span id="dots"></span></div>');

        $.ajax({
            url: 'build_software_command.raw',
            method: 'POST',
            data: JSON.stringify({'command': button.data('update')}),
            xhrFields: {
                onprogress: function (e) {
                    var this_response, response = e.currentTarget.response;
                    response = response.trim();
                    if (last_response_len === false) {
                        this_response = response;
                        last_response_len = response.length;
                    }
                    else {
                        this_response = response.substring(last_response_len);
                        last_response_len = response.length;
                    }
                    contentBody.append(this_response);
                    scrollDown();
                    responseCount++;
                }
            }
        }).done(function (data) {
            if (contentBody.text().length === 0) {
                contentBody.append(data.trim());
            }
            afterBuild('Done!')
        });

        setTimeout(function() { checkProcess() }, 1000);
        return false;
    });

    $('#notifications').on('click', 'a.showLogButton',  function () {
        var button = $(this);
        var last_response_len = false;
        var contentBody = $('#modal-body');
        var closeButton = $('#modal-close-button');
        var responseCount = 1;

        contentBody.empty();
        modalBody.modal('show');
        $('.progress').show();
        closeButton.button('loading');
        contentBody.append('<div>Opening log<span id="dots"></span></div>');
        startLoading();
        disableForms();

        xhr = $.ajax({
            url: 'show_log.raw',
            method: 'POST',
            data: JSON.stringify({'log-file': ''+button.data('log-file')+''}),
            xhrFields: {
                onprogress: function (e) {
                    var this_response, response = e.currentTarget.response;
                    response = response.trim();
                    if (last_response_len === false) {
                        this_response = response;
                        last_response_len = response.length;
                    }
                    else {
                        this_response = response.substring(last_response_len);
                        last_response_len = response.length;
                    }
                    contentBody.append(this_response);
                    scrollDown();
                    responseCount++;
                }
            }
        }).done(function (data) {
            if (contentBody.text().length === 0 || responseCount === 2) {
                contentBody.append(data);
            }
            afterBuild('Done!');
        });
    });

    $('#configuration-file').on('change', function () {
        showConfigurationFields(false);
    });

    $('#application-version').on('change', function () {
        showVersionUpdateFields();
    });

    $('#remove-customized-versions').on('click', function() {
        var button = $(this);
        button.button('loading');

        $.ajax({
            url: 'remove_customized_versions.raw',
            method: 'POST',
            success: function () {
                button.button('reset');
                createNotification('success', 'Custom versions removed successfully');
                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
                updateVersionsInput();
                $('.panel-body.version').empty();
                button.hide();
                $('#remove-version-item').remove();
            }
        });
        return false;
    });

    $('#remove-customized-config').on('click', function () {
        var button = $(this);
        button.button('loading');

        $.ajax({
            url: 'remove_custom_configuration.raw',
            method: 'POST',
            data: JSON.stringify({'item': $('#configuration-file').val()}),
            success: function () {
                button.button('reset');
                createNotification('success', 'Configuration saved successfully');
                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
                showConfigurationFields(false);
            }
        });
        return false;
    });

    $('#save-custom-configuration').on('click', function () {

        var button = $(this);
        button.button('loading');

        $.ajax({
            url: 'update_configuration.raw',
            method: 'POST',
            data: JSON.stringify($('#customize-configuration-form').serializeArray()),
            success: function () {
                button.button('reset');
                createNotification('success', 'Configuration saved successfully');
                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
                showConfigurationFields(false);
            }
        });
        return false;
    });

    $('#save-custom-version').on('click', function() {
        var button = $(this);
        button.button('loading');

        $.ajax({
            url: 'save_custom_version.raw',
            method: 'POST',
            dataType: 'JSON',
            data: JSON.stringify($('#customize-versions-form').serializeArray()),
            success: function (data) {
                button.button('reset');
                if(data.status == 'error') {
                    createNotification('danger', data.text);
                } else {
                    createNotification('success', 'Version updated successfully');
                }
                updateVersionsInput();
                $('.panel-body.version').empty();
                $('#application-version-options').addClass('hide');
                $('#remove-version-item').remove();
                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
            }
        });
        return false;
    });

    $('#add-new-configuration-option').on('click', function() {
        var id = Math.floor((Math.random()*1000)+1);
        var contentElement = $('#configuration-file-options');
        var contentBody = contentElement.find('.panel-body');

        contentBody.prepend('<br/>').prepend(createInput(id, ''));
        return false;
    });

    $('.kill').on('click', function() {
        $.ajax({
            url: 'kill_command.raw',
            success: function() {
                location.reload();
            }
        });
    });

    $('#options-form label').on('click', function() {
        var button = $(this).children();
        if(button.attr('name') == 'webserver') {
            var disabledButtons = {'mod_ruid2': 'yes'};
            if(button.val() == 'nginx') {
                disableButtons(disabledButtons);
            } else {
                enableButtons(disabledButtons);
            }
        }

        if(button.attr('name') == 'php1_mode' || button.attr('name') == 'php2_mode') {
            var disabledButtons = {'mod_ruid2': 'yes'};
            if(button.val() == 'fastcgi' || button.val() == 'php-fpm') {
                disableButtons(disabledButtons);
            } else {
                enableButtons(disabledButtons);
            }
        }

    });

    var interval            = false;
    var procressInterval    = false;
    var pid                 = 0;

    function disableButtons(disabledButtons) {
        for(element in disabledButtons) {
            $('[name="'+element+'"][value="'+disabledButtons[element]+'"]').parent().addClass('disabled');
        }
    }

    function removeVersionItem(button, item) {
        $.ajax({
            url: 'remove_customized_version.raw',
            method: 'POST',
            dataType: 'json',
            data: JSON.stringify({'item': item}),
            success: function (data) {
                button.button('reset');
                if(data.status == 'error') {
                    createNotification('danger', data.text);
                } else {
                    createNotification('success', 'Custom version removed successfully');
                }
                updateVersionsInput();
                $('.panel-body.version').empty();
                $('#application-version-options').addClass('hide');
                $('#remove-version-item').remove();
                $('html, body').animate({
                    scrollTop: notifications.offset().top
                }, 100);
            }
        })
    }

    function scrollDown() {
        if($('#disable_scroll').is(':checked') === false) {
            $('#modal-body').scrollTop(99999);
        }
    }

    function enableButtons(disabledButtons) {
        for(element in disabledButtons) {
            $('[name="'+element+'"][value="'+disabledButtons[element]+'"]').parent().removeClass('disabled');
        }
    }

    function showConfigurationFields(defaultValues) {

        var select = $('#configuration-file');
        var contentElement = $('#configuration-file-options');
        var contentBody = contentElement.find('.panel-body');
        var data = {'configuration-file': select.val(), 'defaults': defaultValues};
        if(select.val() != "") {
            $.ajax({
                url: 'get_configuration.raw',
                method: 'POST',
                dataType: 'json',
                data: JSON.stringify(data),
                success: function (data) {
                    contentBody.empty();
                    if (data.custom == 1) {
                        $('#remove-customized-config').removeClass('hide');
                    } else {
                        $('#remove-customized-config').addClass('hide');
                    }
                    contentElement.removeClass('hide');
                    for (var i = 0; i < data.response.length; i++) {
                        contentBody.append(createInput(i, data.response[i])).append('<br/>');
                    }
                }
            })
        } else {
            contentElement.addClass('hide');
            contentBody.empty();
        }
    }

    function updateVersionsInput() {

        var select = $('#application-version');

        $.ajax({
            url: 'get_versions.raw',
            method: 'GET',
            dataType: 'html',
            success: function (data) {
                select.empty().append(data);
                if(data.search('customized') == -1) {
                    $('#remove-customized-versions').hide();
                } else {
                    $('#remove-customized-versions').show();
                }
            }
        })
    }

    function showVersionUpdateFields() {

        var select = $('#application-version');
        var contentElement = $('#application-version-options');
        var contentBody = contentElement.find('.panel-body');
        var selectValue = select.val().split(':');
        var item = selectValue[0];
        var version = selectValue[1];
        var md5 = selectValue[2];

        contentBody.empty();
        contentElement.removeClass('hide');
        contentBody.append(createVersionInputs(item, version, md5)).append('<br/>');
        if(select.find('option:selected').data('custom') == 1) {
            var button = $('<button>').attr('id', 'remove-version-item').data('item', item).addClass('btn btn-sm btn-danger pull-right input_submit').text('Remove custom version item');
            button.on('click', function() {
                removeVersionItem($(this), $(this).data('item'));
                return false;
            });
            $('#application-version-options .panel-heading .clearfix').append(button);
        }
        $('#save-custom-version').removeClass('disabled');

    }

    function createVersionInputs(item, version, md5) {

        var content = $('<div>');

        var div = $('<div>');
        div.addClass('form-group');

        var versionLabel = $('<label>');
        versionLabel.text('Version');

        var itemVersionInput = $('<input>');
        itemVersionInput.attr('name', 'version_' + item);
        itemVersionInput.attr('id', 'version_' + item);
        itemVersionInput.addClass('form-control');
        itemVersionInput.val(version);

        div.append(versionLabel);
        div.append(itemVersionInput);
        content.append(div);

        var div = $('<div>');
        div.addClass('form-group');

        var md5Label = $('<label>');
        md5Label.text('MD5 (not required)');

        var itemMd5Input = $('<input>');
        itemMd5Input.attr('name', 'md5_' + item);
        itemMd5Input.attr('id', 'md5_' + item);
        itemMd5Input.addClass('form-control');
        itemMd5Input.val(md5);

        div.append(md5Label);
        div.append(itemMd5Input);

        content.append(div);

        return content;
    }

    function createInput(id, value) {
        var div = $('<div>');
        div.addClass('input-group');

        var label = $('<span>');
        label.text('--');
        label.addClass('input-group-addon');

        var input = $('<input>');
        input.attr('name', 'option_' + id);
        input.attr('id', 'option_' + id);
        input.addClass('form-control');
        input.val(value);

        var removeLabel = $('<button>');
        removeLabel.text('-');
        removeLabel.attr('title', 'Remove item');
        removeLabel.attr('type', 'button');
        removeLabel.addClass('btn btn-xs btn-danger btn-remove');
        removeLabel.on('click', function() {
            $(this).parent().next().remove();
            $(this).parent().remove();
        });

        div.append(label);
        div.append(input);
        div.append(removeLabel);

        return div;
    }

    function afterBuild(append)
    {
        if(append != "") {
            contentBody.append('<div><strong>'+append+'</strong></div>');
        }
        scrollDown();
        closeButton.button('reset');
        $('.progress').hide();
        clearInterval(interval);
        clearInterval(procressInterval);
        pid = 0;
    }

    function checkProcess() {
        $.getJSON('check_process.raw', {'pid': pid}).done(function(data){
            if (data.status == "false") {
                if($('#notifications').html() != "") {
                    enableForms();
                }
                setTimeout(function() { checkProcess(); }, 15000);
            } else {
                pid = data.pid;
                disableForms(data.pid, data.show_log);
                setTimeout(function() { checkProcess(); }, 5000);
            }
        }).error(function(data){
            setTimeout(function() { checkProcess(); }, 1000);
        });
    }

    function startLoading() {
        var intervalMs = 300;
        clearInterval(interval);
        interval = setInterval("iterateDots()", intervalMs);
    }

    function createNotification(status, message) {
        notifications.empty();
        if(status != 'warning') {
            var closeButton = '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>';
        } else {
            var closeButton = '';
        }
        notifications.append('<div class="alert alert-' + status + '">' + message + ' ' + closeButton + '</div>');
    }

    function disableForms(pid, show_log) {
        $('#options-form, #update-software-form, #build-software-form, #update-software-configuration-form, #customize-configuration-form').find('input, textarea, button:not(".close"), select').attr('disabled', 'disabled');
        $('#options-form .btn, #update-software-form .btn, #build-software-form .btn, #update-software-configuration-form .btn, #customize-configuration-form .btn').addClass('disabled');
        if(pid) {
            createNotification('warning', 'Build process in progress. PID: '+pid+' (<a href="#" class="kill">kill</a>) '+show_log);
            $('.showLogButton').bind('click');
        } else {
            createNotification('warning', 'Build process in progress. PID: <?php echo trim($pid); ?> (<a href="#" class="kill">kill</a>) <?php echo showViewLog($pid); ?>');
        }
    }

    function enableForms() {
        $('#options-form, #update-software-form, #build-software-form, #update-software-configuration-form, #customize-configuration-form').find('input, textarea, button, select').attr('disabled', false);
        $('#options-form .btn, #update-software-form .btn, #build-software-form .btn, #update-software-configuration-form .btn, #customize-configuration-form .btn').removeClass('disabled');
        $('#notifications .alert').removeClass('alert-warning').addClass('alert-success');
        setTimeout(function () {
            $('#notifications').empty()
        }, 3000);
        clearInterval(procressInterval);
    }

});

function iterateDots() {
    var el = $('#dots');
    var dotsStr = el.text();
    var dotsLen = dotsStr.length;

    var maxDots = 3;
    el.text(dotsLen < maxDots ? dotsStr + '.' : '');
}

</script>
